<?php
/**
 * فایل SSO و راه‌اندازی Web Service برای Moodle (Royal Moodle Sync)
 *
 * نصب:
 * 1. این فایل را در root Moodle قرار دهید (همان مسیر config.php)
 * 2. یا از وردپرس در تنظیمات پلاگین فایل را دانلود کنید (با WP_URL و JWT_SECRET و MWS_SETUP_KEY از پیش پر شده)
 *
 * ساخت خودکار توکن:
 * بعد از قرار دادن فایل، یک بار این آدرس را در مرورگر باز کنید (با کاربر مدیر مودل لاگین باشید):
 *   https://your-moodle.com/mws-sso.php?mws_setup=1&key=YOUR_MWS_SETUP_KEY
 * توکن نمایش داده شده را در تنظیمات وردپرس کپی کنید.
 */

// ─── تنظیمات (در صورت دانلود از وردپرس، این مقادیر از پیش پر می‌شوند) ───
define('WP_URL', 'https://onlinepersianlearning.com');
define('JWT_SECRET', 'YOUR_SECRET_KEY_HERE');
define('MWS_SETUP_KEY', 'REPLACE_ME'); // کلید یکبار برای اجرای راه‌اندازی؛ بعد از دانلود از وردپرس پر می‌شود

// ─── حالت راه‌اندازی: ساخت سرویس و توکن در مودل ───
if (!empty($_GET['mws_setup']) && $_GET['mws_setup'] === '1' && !empty($_GET['key'])) {
    if ($_GET['key'] !== MWS_SETUP_KEY || MWS_SETUP_KEY === 'REPLACE_ME') {
        header('Content-Type: text/html; charset=utf-8');
        die('دسترسی غیرمجاز. کلید راه‌اندازی را بررسی کنید یا از وردپرس فایل را دوباره دانلود کنید.');
    }

    require_once __DIR__ . '/config.php';
    require_once $CFG->libdir . '/setuplib.php';
    require_once $CFG->libdir . '/authlib.php';
    require_login(null, false, null, false, true);
    if (!is_siteadmin()) {
        header('Content-Type: text/html; charset=utf-8');
        die('فقط مدیر سایت مجاز به اجرای راه‌اندازی است. لطفاً با حساب مدیر وارد شوید.');
    }

    $required_functions = array(
        'core_webservice_get_site_info',
        'core_user_get_users',
        'core_user_create_users',
        'core_user_update_users',
        'core_course_get_courses',
        'core_course_get_courses_by_field',
        'core_course_create_courses',
        'core_course_update_courses',
        'core_course_get_categories',
        'core_course_create_categories',
        'core_course_update_categories',
        'enrol_manual_enrol_users',
        'enrol_manual_unenrol_users',
        'core_enrol_get_users_courses',
    );

    $service_shortname = 'royal_moodle_sync';
    $service_name = 'Royal Moodle Sync';

    $service = $DB->get_record('external_services', array('shortname' => $service_shortname));
    if (!$service) {
        $service = new stdClass();
        $service->name = $service_name;
        $service->shortname = $service_shortname;
        $service->enabled = 1;
        $service->restrictedusers = 0;
        $service->component = null;
        $service->requiredcapability = null;
        $service->timecreated = time();
        $service->timemodified = time();
        if (property_exists($service, 'downloadfiles')) {
            $service->downloadfiles = 0;
        }
        if (property_exists($service, 'uploadfiles')) {
            $service->uploadfiles = 0;
        }
        $service->id = $DB->insert_record('external_services', $service);
    } else {
        $service->enabled = 1;
        $service->timemodified = time();
        $DB->update_record('external_services', $service);
    }

    foreach ($required_functions as $funcname) {
        $func = $DB->get_record('external_functions', array('name' => $funcname), 'id');
        if (!$func) {
            continue;
        }
        $exists = $DB->record_exists('external_services_functions', array(
            'externalserviceid' => $service->id,
            'functionid' => $func->id
        ));
        if (!$exists) {
            $rec = new stdClass();
            $rec->externalserviceid = $service->id;
            $rec->functionid = $func->id;
            $DB->insert_record('external_services_functions', $rec);
        }
    }

    require_once $CFG->libdir . '/externallib.php';
    $context = context_system::instance();

    $token_value = null;
    if (function_exists('external_generate_token')) {
        $token_value = external_generate_token(EXTERNAL_TOKEN_PERMANENT, $service, $USER->id, $context, 0, '');
    } elseif (class_exists('core_external\util')) {
        $token_value = \core_external\util::generate_token(
            EXTERNAL_TOKEN_PERMANENT,
            $service,
            $USER->id,
            $context,
            0,
            '',
            'Royal Moodle Sync'
        );
    }

    if (empty($token_value)) {
        header('Content-Type: text/html; charset=utf-8');
        echo '<!DOCTYPE html><html dir="rtl" lang="fa"><head><meta charset="utf-8"><title>خطا</title></head><body>';
        echo '<p>ساخت توکن با خطا مواجه شد. مطمئن شوید Web services در مودل فعال است (Site administration > Advanced features).</p>';
        echo '</body></html>';
        exit;
    }

    header('Content-Type: text/html; charset=utf-8');
    echo '<!DOCTYPE html><html dir="rtl" lang="fa"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">';
    echo '<title>توکن Royal Moodle Sync</title>';
    echo '<style>body{font-family:tahoma,sans-serif;max-width:600px;margin:40px auto;padding:20px;background:#f5f5f5;}';
    echo '.box{background:#fff;border:1px solid #ddd;border-radius:8px;padding:24px;margin:20px 0;}';
    echo 'h1{color:#0073aa;margin-top:0;} .token{background:#f0f0f0;padding:12px;word-break:break-all;font-family:monospace;font-size:14px;border-radius:4px;}';
    echo '.warn{background:#fff3cd;border-right:4px solid #ffc107;padding:12px;margin-top:16px;border-radius:4px;}</style></head><body>';
    echo '<div class="box"><h1>✅ راه‌اندازی انجام شد</h1>';
    echo '<p>این توکن را در وردپرس در <strong>تنظیمات پلاگین Royal Moodle Sync</strong> در فیلد «Web Service Token» قرار دهید.</p>';
    echo '<p><strong>توکن:</strong></p><div class="token">' . htmlspecialchars($token_value) . '</div>';
    echo '<p><button type="button" onclick="navigator.clipboard.writeText(this.previousElementSibling.textContent);alert(\'کپی شد\');">کپی توکن</button></p>';
    echo '<div class="warn"><strong>امنیت:</strong> این صفحه را فقط یک بار استفاده کنید و آدرس را به اشتراک نگذارید. در صورت نیاز می‌توانید دوباره با همین آدرس توکن جدید بسازید.</div>';
    echo '</div></body></html>';
    exit;
}

// ─── بخش SSO (ورود با توکن وردپرس) ───
$token = isset($_GET['mws_sso_token']) ? $_GET['mws_sso_token'] : '';
$email = isset($_GET['mws_sso_email']) ? $_GET['mws_sso_email'] : '';
$user_id = isset($_GET['mws_sso_user_id']) ? intval($_GET['mws_sso_user_id']) : 0;
$redirect = isset($_GET['redirect']) ? $_GET['redirect'] : '';

if (empty($token) || empty($email)) {
    die('Invalid SSO request');
}

function mws_validate_jwt_token($token, $secret) {
    $parts = explode('.', $token);
    if (count($parts) !== 3) {
        return false;
    }
    list($base64UrlHeader, $base64UrlPayload, $base64UrlSignature) = $parts;
    $payload = json_decode(base64_decode(str_replace(['-', '_'], ['+', '/'], $base64UrlPayload)), true);
    if (!$payload || !is_array($payload)) {
        return false;
    }
    if (isset($payload['exp'])) {
        $ten_years = 10 * 365 * 24 * 60 * 60;
        if ($payload['exp'] < (time() + $ten_years - 86400) && $payload['exp'] < time()) {
            return false;
        }
    }
    $signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, $secret, true);
    $base64UrlSignatureCheck = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));
    if ($base64UrlSignature !== $base64UrlSignatureCheck) {
        return false;
    }
    return $payload;
}

if (JWT_SECRET === 'YOUR_SECRET_KEY_HERE' || empty(JWT_SECRET)) {
    die('Error: JWT_SECRET is not configured. Please set the secret key in this file.');
}

$payload = mws_validate_jwt_token($token, JWT_SECRET);
if (!$payload) {
    $parts = explode('.', $token);
    if (count($parts) !== 3) {
        die('Invalid token format');
    }
    $test_payload = json_decode(base64_decode(str_replace(['-', '_'], ['+', '/'], $parts[1])), true);
    if ($test_payload && isset($test_payload['exp']) && $test_payload['exp'] < time()) {
        die('Token expired. Please try again.');
    }
    die('Invalid token. Please check that JWT_SECRET in this file matches the secret key in WordPress.');
}

if (strtolower(trim($payload['email'])) !== strtolower(trim($email))) {
    die('Email mismatch');
}

require_once __DIR__ . '/config.php';
require_once $CFG->libdir . '/authlib.php';

$user = $DB->get_record('user', array('email' => $email, 'deleted' => 0));
if (!$user) {
    die('User not found in Moodle');
}

complete_user_login($user);

if (!empty($redirect)) {
    redirect($redirect);
} else {
    redirect($CFG->wwwroot);
}