jQuery(document).ready(function($) {
    'use strict';
    
    // همگام‌سازی دسته‌بندی‌ها
    $('#mws-sync-categories').on('click', function(e) {
        e.preventDefault();
        var $button = $(this);
        var $status = $('#categories-status');
        
        $button.prop('disabled', true);
        $status.removeClass('success error').addClass('loading').text('در حال همگام‌سازی...');
        
        $.ajax({
            url: mwsAjax.ajaxurl,
            type: 'POST',
            data: {
                action: 'mws_sync_categories',
                nonce: mwsAjax.nonce
            },
            success: function(response) {
                $button.prop('disabled', false);
                $status.removeClass('loading');
                
                if (response.success) {
                    $status.addClass('success').text('✓ ' + response.data.message);
                    $('#mws-ajax-result').html(
                        '<div class="notice notice-success"><p>' + 
                        response.data.message + 
                        '</p></div>'
                    );
                } else {
                    $status.addClass('error').text('✗ خطا');
                    $('#mws-ajax-result').html(
                        '<div class="notice notice-error"><p>' + 
                        (response.data.message || 'خطا در همگام‌سازی') + 
                        '</p></div>'
                    );
                }
            },
            error: function() {
                $button.prop('disabled', false);
                $status.removeClass('loading').addClass('error').text('✗ خطا در ارتباط');
                $('#mws-ajax-result').html(
                    '<div class="notice notice-error"><p>خطا در ارتباط با سرور</p></div>'
                );
            }
        });
    });
    
    // همگام‌سازی دوره‌ها - با یک کلیک تا انتها
    var mwsSyncCoursesOffset = 0;
    var mwsSyncCoursesInProgress = false;

    function mwsDoSyncCoursesBatch() {
        var $button = $('#mws-sync-courses');
        var $status = $('#courses-status');
        var batchSize = 20;

        $.ajax({
            url: mwsAjax.ajaxurl,
            type: 'POST',
            data: {
                action: 'mws_sync_courses',
                nonce: mwsAjax.nonce,
                offset: mwsSyncCoursesOffset,
                batch_size: batchSize
            },
            success: function(response) {
                if (response.success && response.data) {
                    var d = response.data;
                    $status.addClass('success').text('✓ پیشرفت: ' + d.processed + '/' + d.total + (d.has_more ? '...' : ''));
                    $('#mws-ajax-result').html(
                        '<div class="notice notice-success"><p>' + d.message + '</p></div>'
                    );

                    if (d.has_more) {
                        mwsSyncCoursesOffset = d.next_offset;
                        setTimeout(mwsDoSyncCoursesBatch, 400);
                    } else {
                        mwsSyncCoursesOffset = 0;
                        mwsSyncCoursesInProgress = false;
                        $button.prop('disabled', false).text('همگام‌سازی دوره‌ها');
                        $status.text('✓ تکمیل شد');
                    }
                } else {
                    mwsSyncCoursesInProgress = false;
                    $button.prop('disabled', false).text('همگام‌سازی دوره‌ها');
                    $status.removeClass('loading').addClass('error').text('✗ خطا');
                    $('#mws-ajax-result').html(
                        '<div class="notice notice-error"><p>' + (response.data && response.data.message ? response.data.message : 'خطا در همگام‌سازی') + '</p></div>'
                    );
                }
            },
            error: function() {
                mwsSyncCoursesInProgress = false;
                var $button = $('#mws-sync-courses');
                $button.prop('disabled', false).text('همگام‌سازی دوره‌ها');
                $('#courses-status').removeClass('loading').addClass('error').text('✗ خطا در ارتباط');
                $('#mws-ajax-result').html(
                    '<div class="notice notice-error"><p>خطا در ارتباط با سرور</p></div>'
                );
            }
        });
    }

    $('#mws-sync-courses').on('click', function(e) {
        e.preventDefault();
        var $button = $(this);
        var $status = $('#courses-status');
        var batchSize = 20;

        if (mwsSyncCoursesInProgress) return;

        if (mwsSyncCoursesOffset === 0 && !confirm('همگام‌سازی تمام دوره‌ها با یک کلیک شروع می‌شود (هر بار ' + batchSize + ' دوره). ادامه؟')) {
            return;
        }

        mwsSyncCoursesInProgress = true;
        $button.prop('disabled', true);
        $status.removeClass('success error').addClass('loading').text('در حال همگام‌سازی...');

        mwsDoSyncCoursesBatch();
    });
    
    // بارگذاری آمار همگام‌سازی کاربران
    function mwsLoadUserSyncStats() {
        $.post(mwsAjax.ajaxurl, {
            action: 'mws_get_user_sync_stats',
            nonce: mwsAjax.nonce
        }, function(response) {
            if (response.success && response.data) {
                $('#mws-user-sync-stats .mws-stats-total').text('تعداد کل کاربران: ' + response.data.total);
                $('#mws-user-sync-stats .mws-stats-synced').text('همگام‌سازی شده با Moodle: ' + response.data.synced);
            }
        });
    }
    mwsLoadUserSyncStats();

    // همگام‌سازی کاربران (دسته‌ای) - با یک کلیک تا انتها
    var mwsSyncUsersOffset = 0;
    var mwsSyncInProgress = false;

    function mwsDoSyncBatch() {
        var $button = $('#mws-sync-users');
        var $status = $('#users-status');
        var batchSize = mwsAjax.batch_size || 100;

        $.ajax({
            url: mwsAjax.ajaxurl,
            type: 'POST',
            data: {
                action: 'mws_sync_all_users',
                nonce: mwsAjax.nonce,
                offset: mwsSyncUsersOffset
            },
            success: function(response) {
                if (response.success && response.data) {
                    var d = response.data;
                    $status.addClass('success').text('✓ کاربران ' + d.from + ' تا ' + d.to + ' از ' + d.total_users + (d.has_more ? '...' : ''));
                    $('#mws-ajax-result').html(
                        '<div class="notice notice-success"><p>' + d.message + '</p></div>'
                    );

                    if (d.has_more) {
                        mwsSyncUsersOffset = d.next_offset;
                        mwsLoadUserSyncStats();
                        setTimeout(mwsDoSyncBatch, 400);
                    } else {
                        mwsSyncUsersOffset = 0;
                        mwsSyncInProgress = false;
                        $button.prop('disabled', false).text('همگام‌سازی کاربران WordPress به Moodle');
                        $status.text('✓ تکمیل شد');
                        mwsLoadUserSyncStats();
                    }
                } else {
                    mwsSyncInProgress = false;
                    $button.prop('disabled', false).text('همگام‌سازی کاربران WordPress به Moodle');
                    $status.removeClass('loading').addClass('error').text('✗ خطا');
                    $('#mws-ajax-result').html(
                        '<div class="notice notice-error"><p>' + (response.data && response.data.message ? response.data.message : 'خطا در همگام‌سازی') + '</p></div>'
                    );
                }
            },
            error: function() {
                mwsSyncInProgress = false;
                var $button = $('#mws-sync-users');
                $button.prop('disabled', false).text('همگام‌سازی کاربران WordPress به Moodle');
                $('#users-status').removeClass('loading').addClass('error').text('✗ خطا در ارتباط');
                $('#mws-ajax-result').html(
                    '<div class="notice notice-error"><p>خطا در ارتباط با سرور</p></div>'
                );
            }
        });
    }

    $('#mws-sync-users').on('click', function(e) {
        e.preventDefault();
        var $button = $(this);
        var $status = $('#users-status');
        var batchSize = mwsAjax.batch_size || 100;

        if (mwsSyncInProgress) return;

        if (mwsSyncUsersOffset === 0 && !confirm('همگام‌سازی تمام کاربران با یک کلیک شروع می‌شود (هر بار ' + batchSize + ' کاربر). ادامه؟')) {
            return;
        }

        mwsSyncInProgress = true;
        $button.prop('disabled', true);
        $status.removeClass('success error').addClass('loading').text('در حال همگام‌سازی...');

        mwsDoSyncBatch();
    });
    
    // همگام‌سازی تک دوره از لیست
    $(document).on('click', '.mws-sync-single-course', function(e) {
        e.preventDefault();
        var $button = $(this);
        var postId = $button.data('post-id');
        var $status = $('.mws-sync-status-' + postId);
        
        $button.prop('disabled', true);
        $status.text('در حال سینک...').css('color', '#2271b1');
        
        $.ajax({
            url: mwsAjax.ajaxurl,
            type: 'POST',
            data: {
                action: 'mws_sync_single_course',
                post_id: postId,
                nonce: mwsAjax.nonce
            },
            success: function(response) {
                $button.prop('disabled', false);
                
                if (response.success) {
                    $status.text('✓ موفق').css('color', '#00a32a');
                    $button.text('به‌روزرسانی');
                    // به‌روزرسانی شناسه Moodle در ستون
                    location.reload();
                } else {
                    $status.text('✗ خطا').css('color', '#d63638');
                }
            },
            error: function() {
                $button.prop('disabled', false);
                $status.text('✗ خطا').css('color', '#d63638');
            }
        });
    });
    
    // همگام‌سازی تک دسته‌بندی از لیست
    $(document).on('click', '.mws-sync-single-category', function(e) {
        e.preventDefault();
        var $button = $(this);
        var termId = $button.data('term-id');
        var $status = $('.mws-sync-status-' + termId);
        
        $button.prop('disabled', true);
        $status.text('در حال سینک...').css('color', '#2271b1');
        
        $.ajax({
            url: mwsAjax.ajaxurl,
            type: 'POST',
            data: {
                action: 'mws_sync_single_category',
                term_id: termId,
                nonce: mwsAjax.nonce
            },
            success: function(response) {
                $button.prop('disabled', false);
                
                if (response.success) {
                    $status.text('✓ موفق').css('color', '#00a32a');
                    $button.text('به‌روزرسانی');
                    // به‌روزرسانی شناسه Moodle در ستون
                    location.reload();
                } else {
                    $status.text('✗ خطا').css('color', '#d63638');
                }
            },
            error: function() {
                $button.prop('disabled', false);
                $status.text('✗ خطا').css('color', '#d63638');
            }
        });
    });
    
    // دریافت کاربران از Moodle
    $('#mws-import-users').on('click', function(e) {
        e.preventDefault();
        var $button = $(this);
        var $status = $('#import-users-status');
        
        if (!confirm('آیا مطمئن هستید که می‌خواهید کاربران Moodle را به WordPress بیاورید؟ این عملیات ممکن است زمان‌بر باشد.')) {
            return;
        }
        
        $button.prop('disabled', true);
        $status.removeClass('success error').addClass('loading').text('در حال دریافت...');
        
        $.ajax({
            url: mwsAjax.ajaxurl,
            type: 'POST',
            data: {
                action: 'mws_import_users_from_moodle',
                nonce: mwsAjax.nonce
            },
            success: function(response) {
                $button.prop('disabled', false);
                $status.removeClass('loading');
                
                if (response.success) {
                    $status.addClass('success').text('✓ ' + response.data.message);
                    
                    var html = '<div class="notice notice-success"><p><strong>' + response.data.message + '</strong></p></div>';
                    
                    // نمایش خطاها در یک جدول
                    if (response.data.errors && response.data.errors.length > 0) {
                        html += '<div class="mws-import-errors" style="margin-top: 20px;">';
                        html += '<h3 style="margin-bottom: 10px;">خطاهای Import (' + response.data.errors.length + ' مورد):</h3>';
                        html += '<table class="wp-list-table widefat fixed striped" style="margin-top: 10px;">';
                        html += '<thead><tr>';
                        html += '<th style="width: 80px;">شناسه Moodle</th>';
                        html += '<th>نام کاربری</th>';
                        html += '<th>ایمیل</th>';
                        html += '<th>علت خطا</th>';
                        html += '</tr></thead>';
                        html += '<tbody>';
                        
                        $.each(response.data.errors, function(index, error) {
                            var moodleId = error.moodle_id || '-';
                            var username = error.username || '-';
                            var email = error.email || '-';
                            var reason = error.reason || 'نامشخص';
                            
                            html += '<tr>';
                            html += '<td><strong>' + moodleId + '</strong></td>';
                            html += '<td>' + username + '</td>';
                            html += '<td>' + email + '</td>';
                            html += '<td><span style="color: #d63638;">' + reason + '</span></td>';
                            html += '</tr>';
                        });
                        
                        html += '</tbody></table>';
                        html += '</div>';
                    }
                    
                    $('#mws-ajax-result').html(html);
                } else {
                    $status.addClass('error').text('✗ خطا');
                    $('#mws-ajax-result').html(
                        '<div class="notice notice-error"><p>' + 
                        (response.data.message || 'خطا در دریافت کاربران') + 
                        '</p></div>'
                    );
                }
            },
            error: function() {
                $button.prop('disabled', false);
                $status.removeClass('loading').addClass('error').text('✗ خطا در ارتباط');
                $('#mws-ajax-result').html(
                    '<div class="notice notice-error"><p>خطا در ارتباط با سرور</p></div>'
                );
            }
        });
    });
});

