# پلاگین همگام‌سازی Moodle و WordPress

پلاگین ساده و رایگان برای همگام‌سازی بین Moodle و WordPress بدون نیاز به لایسنس یا توکن اضافی.

## ویژگی‌ها

- ✅ همگام‌سازی خودکار کاربران بین WordPress و Moodle
- ✅ همگام‌سازی دوره‌های Moodle با WordPress
- ✅ مدیریت ثبت‌نام کاربران در دوره‌ها
- ✅ ادغام با WooCommerce برای فروش دوره‌ها
- ✅ شورت‌کدهای کاربردی برای نمایش دوره‌ها
- ✅ سیستم لاگ برای ردیابی عملیات
- ✅ رابط کاربری ساده و فارسی

## نصب

1. فایل‌های پلاگین را در پوشه `wp-content/plugins/moodle-wp-sync/` قرار دهید
2. از پنل WordPress پلاگین را فعال کنید
3. به منوی **Moodle Sync** بروید و تنظیمات را وارد کنید

## تنظیمات Moodle

قبل از استفاده از پلاگین، باید Web Service را در Moodle فعال کنید:

### 1. فعال‌سازی Web Services

1. به `Site administration > Advanced features` بروید
2. گزینه `Enable web services` را فعال کنید
3. ذخیره کنید

### 2. فعال‌سازی REST Protocol

1. به `Site administration > Plugins > Web services > Manage protocols` بروید
2. گزینه `REST protocol` را فعال کنید

### 3. ایجاد Web Service

1. به `Site administration > Plugins > Web services > External services` بروید
2. روی `Add` کلیک کنید
3. نام سرویس را وارد کنید (مثلاً: WordPress Sync)
4. گزینه `Enable` را فعال کنید
5. ذخیره کنید

### 4. افزودن توابع مورد نیاز

در صفحه ویرایش سرویس، به بخش `Functions` بروید و توابع زیر را اضافه کنید:

- `core_user_create_users`
- `core_user_update_users`
- `core_user_get_users`
- `core_course_get_courses`
- `enrol_manual_enrol_users`
- `enrol_manual_unenrol_users`
- `core_enrol_get_users_courses`
- `core_webservice_get_site_info`

### 5. ایجاد Token

1. به `Site administration > Plugins > Web services > Manage tokens` بروید
2. روی `Create token` کلیک کنید
3. کاربر را انتخاب کنید
4. سرویسی که ایجاد کردید را انتخاب کنید
5. IP address را خالی بگذارید (یا IP سرور WordPress را وارد کنید)
6. Token را کپی کنید

### 6. تنظیمات در WordPress

1. به `Moodle Sync > تنظیمات` بروید
2. آدرس Moodle را وارد کنید (مثلاً: `https://your-moodle-site.com`)
3. Token را وارد کنید
4. روی `تست اتصال` کلیک کنید تا مطمئن شوید اتصال برقرار است

## استفاده

### شورت‌کدها

#### نمایش لیست دوره‌ها

```
[moodle_courses]
```

پارامترهای اختیاری:
- `limit`: تعداد دوره‌ها (پیش‌فرض: 10)
- `columns`: تعداد ستون‌ها (پیش‌فرض: 3)
- `category`: شناسه دسته‌بندی Moodle
- `show_enroll`: نمایش دکمه ثبت‌نام (yes/no)

مثال:
```
[moodle_courses limit="6" columns="2"]
```

#### نمایش یک دوره

```
[moodle_course moodle_id="123"]
```

یا:
```
[moodle_course id="456"]
```

#### دکمه ثبت‌نام

```
[moodle_enroll_button course_id="123"]
```

پارامترهای اختیاری:
- `text`: متن دکمه ثبت‌نام
- `unenroll_text`: متن دکمه لغو ثبت‌نام

#### دوره‌های من

```
[moodle_my_courses]
```

### ادغام با WooCommerce

برای اتصال محصولات WooCommerce به دوره‌های Moodle:

1. در صفحه ویرایش محصول، به بخش `Custom Fields` بروید
2. یک فیلد متا با نام `mws_linked_course_id` اضافه کنید
3. شناسه دوره Moodle را به عنوان مقدار وارد کنید
4. با تکمیل سفارش، کاربر به صورت خودکار در دوره ثبت‌نام می‌شود

یا می‌توانید از کد زیر در `functions.php` تم استفاده کنید:

```php
add_action('woocommerce_product_options_general_product_data', function() {
    global $woocommerce, $post;
    echo '<div class="product_custom_field">';
    woocommerce_wp_text_input(array(
        'id' => 'mws_linked_course_id',
        'placeholder' => 'شناسه دوره Moodle',
        'label' => 'شناسه دوره Moodle',
        'desc_tip' => 'true',
        'description' => 'شناسه دوره Moodle که با این محصول مرتبط است'
    ));
    echo '</div>';
});

add_action('woocommerce_process_product_meta', function($post_id) {
    $moodle_course_id = $_POST['mws_linked_course_id'];
    if (!empty($moodle_course_id)) {
        update_post_meta($post_id, 'mws_linked_course_id', esc_attr($moodle_course_id));
    }
});
```

## ساختار فایل‌ها

```
moodle-wp-sync/
├── moodle-wp-sync.php          # فایل اصلی پلاگین
├── includes/
│   ├── class-moodle-api.php    # کلاس ارتباط با Moodle API
│   ├── class-user-sync.php     # همگام‌سازی کاربران
│   ├── class-course-sync.php   # همگام‌سازی دوره‌ها
│   ├── class-enrollment.php    # مدیریت ثبت‌نام
│   └── class-admin.php         # صفحه تنظیمات ادمین
├── assets/
│   ├── admin.css               # استایل‌های ادمین
│   ├── admin.js                # اسکریپت‌های ادمین
│   └── frontend.css            # استایل‌های فرانت‌اند
└── README.md                   # این فایل
```

## نیازمندی‌ها

- WordPress 5.0 یا بالاتر
- PHP 7.2 یا بالاتر
- Moodle 3.0 یا بالاتر
- دسترسی به Web Service API در Moodle

## پشتیبانی

برای گزارش باگ یا پیشنهاد ویژگی جدید، لطفاً از Issues استفاده کنید.

## لایسنس

این پلاگین تحت لایسنس GPL v2 یا بالاتر منتشر شده است.

## تغییرات

### نسخه 1.0.0
- انتشار اولیه
- همگام‌سازی کاربران
- همگام‌سازی دوره‌ها
- مدیریت ثبت‌نام
- ادغام با WooCommerce
- سیستم لاگ
- شورت‌کدها

