# راهنمای نصب SSO در Moodle

برای فعال‌سازی SSO بین WordPress و Moodle، باید فایل `moodle-sso-handler.php` را در Moodle نصب کنید.

## مراحل نصب:

### 1. کپی فایل به Moodle

فایل `mws-sso.php` را در **root Moodle** کپی کنید (همان مسیری که `config.php` است):
```
/path/to/moodle/mws-sso.php
```

**مثال:** اگر Moodle شما در `/var/www/html/moodle` است، فایل را در `/var/www/html/moodle/mws-sso.php` قرار دهید.

**نکته:** نام فایل از قبل `mws-sso.php` است و نیازی به تغییر نام نیست.

### 2. تنظیم Secret Key

در فایل `mws-sso.php`، خط 15 را پیدا کنید:
```php
define('JWT_SECRET', 'YOUR_SECRET_KEY_HERE');
```

Secret key را از WordPress دریافت کنید:
1. به WordPress بروید
2. به **تنظیمات > سینک مودل رویال** بروید
3. در بخش **SSO Secret Key**، روی دکمه **کپی** کلیک کنید
4. در فایل `mws-sso.php`، `YOUR_SECRET_KEY_HERE` را با Secret key کپی شده جایگزین کنید

### 3. تنظیم آدرس WordPress

در فایل `mws-sso.php`، خط 14 را پیدا کنید:
```php
define('WP_URL', 'https://onlinepersianlearning.com');
```

آدرس WordPress خود را جایگزین کنید.

### 4. تنظیم دسترسی

اطمینان حاصل کنید که فایل `mws-sso.php` قابل دسترسی است:
```bash
chmod 644 /path/to/moodle/mws-sso.php
```

### 5. تست

بعد از نصب، لینک SSO باید کار کند و کاربران به صورت خودکار به Moodle لاگین شوند.

## نکات مهم:

- فایل باید در **root Moodle** قرار گیرد (همان مسیری که `config.php` است)
- نام فایل باید `mws-sso.php` باشد
- Secret key باید در WordPress و Moodle یکسان باشد
- آدرس WordPress باید صحیح باشد

## نحوه دریافت Secret Key از WordPress:

### روش ساده (توصیه می‌شود):

1. به WordPress بروید
2. به **تنظیمات > سینک مودل رویال** بروید
3. در بخش **SSO Secret Key**، Secret key را مشاهده می‌کنید
4. روی دکمه **کپی** کلیک کنید
5. در فایل `mws-sso.php` در Moodle، خط 15 را پیدا کنید
6. `YOUR_SECRET_KEY_HERE` را با Secret key کپی شده جایگزین کنید

### روش جایگزین (از دیتابیس):

در دیتابیس WordPress:
```sql
SELECT option_value FROM wp_options WHERE option_name = 'mws_sso_secret_key';
```

مقدار `option_value` را کپی کنید و در فایل `mws-sso.php` جایگزین کنید.

